/*
    calls0.c - callbacks 000 through 009 (formerly in calls.c)

    Marc Wolfgram,  3/30/91 11:55:50
    ---------------------------------------------------------------
*/
#pragma noroot
#pragma keep "o/calls0"

#include "calls.h"

segment "F_CALLBACK";

/*
    000
    ---------------------------------------------------------------
*/
word remBadCmdError(long p)
{
    return SetToolError(badSystemCall);
}

/*
    fAddResource 001
    ---------------------------------------------------------------
        word    pCount          min 3
        word    resType         input
        Long    resID           input or retVal
        Handle  resData         input
        word    special         input
        word    resFileID       input
        Pointer resName         input

    Marc Wolfgram,  4/ 7/91 13:12:29
*/
word remAddResource(fResDataRecPtr p)
{
word i, retVal, curFile, curDepth, attr, file;

    retVal = attr = 0;
    file = workList[workIndex].resFileID;
    tempName[0] = 0x00;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch (p->pCount) {
    case 6:
        sprintf(tempName, "*%.31p", p->resName);
        tempName[0] = strlen(&tempName[1]);

    case 5:
        if (p->resFileID)
            file = p->resFileID;

    case 4:
        attr = p->special;

    case 3:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);
        if (p->resType) {
            if (p->resID == 0L)
                p->resID = UniqueResourceID(-1, p->resType);
            AddResource((Handle) p->resData, 0, p->resType, p->resID);
            retVal = toolerror();
            if (retVal == resDupID) {
                p->resID = UniqueResourceID(-1, p->resType);
                AddResource((Handle) p->resData, 0, p->resType, p->resID);
                retVal = toolerror();
            }
            if (retVal == 0) {
                WriteResource(p->resType, p->resID);  /* bullet proof fix */
	            UpdateResourceFile(file);
                SetResourceAttr(attr & 0xffdf, p->resType, p->resID);
                if (tempName[0])
                    RMSetResourceName(p->resType, p->resID, tempName);
                for (i = 0; i < 4; i++) {
            	    if (file == workList[i].resFileID) {
                	    if (tempName[0])
                    	    addItem(i, p->resType, p->resID, tempName);
                	    else
                    	    addItem(i, p->resType, p->resID, 0L);
                        break;
                    }
                }
	    	}
        }
        else
            retVal = resNotFound;
        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fRemoveResource 002
    ---------------------------------------------------------------
        word    pCount          2 or 3
        word    resType         input
        Long    resID;          input or retVal
        word    resFileID       input

    Marc Wolfgram,  4/ 7/91 13:37:11
*/
word remRemoveResource(fResRefRecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch(p->pCount) {
    case 3:
        file = p->resFileID;

    case 2:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        if (file == workList[workIndex].resFileID)
            deleteItem(workIndex, p->resType, p->resID);

        RemoveResource(p->resType, p->resID);
        retVal = (long) toolerror();
        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    remLoadResource 003
    ---------------------------------------------------------------
        word    pCount          3, 5 or 6
        word    resType         input
        Long    resID           input
        Handle  resData;        retVal
        word    special         input (non zero returnes detached handle)
        word    resFileID       input
        Pointer resName         input

    Marc Wolfgram,  4/ 7/91 13:37:11
    				1/16/92 22:20:44   was LoadResource
*/
word remLoadResource(fResDataRecPtr p)
{
word retVal, curFile, curDepth, attr, file, sysRes;
nameSubPtr nameSubP;
fResNameRec namePB;
    sysRes = retVal = 0;
    file = workList[workIndex].resFileID;
    p->resData = (Handle) 0L;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);

    switch(p->pCount) {
    case 6:
        nameSubP = getNameSubRec(workIndex, p->resType, p->resID);
        if (nameSubP->name[0] > 0x08) {
            sprintf(p->resName, "*%.31s", &nameSubP->name[9]);
            p->resName[0] = nameSubP->name[9] - 0x09;
        }
    	else
	    	p->resName[0] = 0x00;

    case 5:
        if (p->resFileID)
            file = p->resFileID;

    case 4:
    case 3:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        attr = SetResAttr(p->resType, p->resID);
        retVal = toolerror();
        if (retVal) {
            if (p->resID > 0x07feffffL) {
                sysRes = SetResourceFileDepth(2);
                attr = SetResAttr(p->resType, p->resID);
                if (toolerror())
                    break;
            }
            else
                break;
        }
        p->resData = LoadResource2(0, &p->special, p->resType, p->resID);
        retVal = toolerror();

        SetResourceAttr(attr, p->resType, p->resID);

        if (sysRes && file == workList[workIndex].resFileID) {
            DetachResource(p->resType, p->resID);
            SetCurResourceFile(file);
            AddResource((Handle) p->resData, attr, p->resType, p->resID);
            WriteResource(p->resType, p->resID);
            addItem(workIndex, p->resType, p->resID, "SYSTEM RESOURCE");

    		AlertArray[0] = &tempName[0];

    		namePB.pCount = 3;
    		namePB.resType = p->resType;
			namePB.resName = &tempName[128];
    		remGetStdTypeName(&namePB);

    		sprintf(tempName, "%p - %0.8lX", &tempName[128], p->resID);
        	AlertArray[0] = tempName;
        	attr = AlertWindow(0x0034, AlertArray, 0x10L);
        }
        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fReleaseResource 004
    ---------------------------------------------------------------
        word    pCount          2 or 3
        word    resType         input
        Long    resID           input or retVal
        word    resFileID       input

    Marc Wolfgram,  4/14/91 14:29:37
*/
word remReleaseResource(fResRefRecPtr p)
{
word retVal, curFile, curDepth, attr, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(2);

    switch(p->pCount) {
    case 3:
        file = p->resFileID;

    case 2:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        attr = GetResourceAttr(p->resType, p->resID);
        retVal = toolerror();
        if (retVal)
            break;

        ReleaseResource(-1, p->resType, p->resID);
        retVal = toolerror();

        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fDetachResource 005
    ---------------------------------------------------------------
        word    pCount          2 or 3
        word    resType         input
        Long    resID           input or retVal
        word    resFileID       input

    Marc Wolfgram,  4/14/91 14:29:37
*/
word remDetachResource(fResRefRecPtr p)
{
word retVal, curFile, curDepth, file;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(2);

    switch(p->pCount) {
    case 3:
        file = p->resFileID;

    case 2:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        DetachResource(p->resType, p->resID);
        retVal = toolerror();

        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    fWriteResource 006
    ---------------------------------------------------------------
        word    pCount          2 or 3
        word    resType         input
        Long    resID           input or retVal
        word    resFileID       input

    Marc Wolfgram,  4/14/91 14:29:37
*/
word remWriteResource(fResRefRecPtr p)
{
word retVal, curFile, curDepth, attr, file;
GrafPortPtr winP;
fEventRec eventPB;

    retVal = 0;
    file = workList[workIndex].resFileID;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(2);

    switch(p->pCount) {
    case 3:
        file = p->resFileID;

    case 2:
        if (!file) {
            retVal = resFileNotFound;
            break;
        }
        SetCurResourceFile(file);

        attr = GetResourceAttr(p->resType, p->resID) & 0xfdff;
        retVal = toolerror();
        if (retVal)
            break;
        SetResourceAttr(0x0020, p->resType, p->resID);  /* force changed */

        WriteResource(p->resType, p->resID);
        retVal = toolerror();
	    UpdateResourceFile(file);

        SetResourceAttr(attr & 0xffdf, p->resType, p->resID);

        if (retVal == 0 && file == workList[workIndex].resFileID) {
            workList[workIndex].wFlag |= 0x4000;
        	winP = findSignature(REM_signature + REM_nselector + workIndex, 0, p->resType, 0L);
        	if (winP) {
            	fTaskRec.wmTaskData = (long) winP;
    			eventPB.resType = p->resType;
    			eventPB.resID = p->resID;
    			eventPB.fFlag = 0x0400;
            	eventPB.taskCode = 15;      /* app4Evt - delete selector item */
            	callREM(_EVENT, (Pointer) &eventPB);
        	}
 		}
        break;

    default:
        retVal = invalidPcount;
    }

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    return SetToolError(retVal);
}

/*
    remGetStdTypeName 007
    ---------------------------------------------------------------
        word    pCount          3
        word    resType         input
        Long    resID;          ignored
        char   *resName         output

    Marc Wolfgram,  7/13/91 12:22:04
*/
word remGetStdTypeName(fResNameRecPtr p)
{
word curFile, curDepth, nlen, retVal;
char *s;

    retVal = 0;
    p->resName[0] = 0x00;

    if (p->pCount != 3)
        retVal = invalidPcount;

    else if (p->resType == 0 || p->resType == 0x8000)
        retVal = resInvalidTypeOrID;

    else {
        curFile = GetCurResourceFile();
        curDepth = SetResourceFileDepth(1);
        SetCurResourceFile(fResID);

        RMGetResourceName(rResName, (long) p->resType + 0x10000L, tempName);
        if (!toolerror()) {
            nlen = sprintf(p->resName, "*%.31p", tempName);
    		ReleaseResource(-1, rResName, (long) p->resType + 0x10000L);
        }
        else {
            s = getREMTypeName(p->resType);
            if (s)
                nlen = sprintf(p->resName, "*%.31p", s);
            else
                nlen = sprintf(p->resName, (char *) strings[21], p->resType);
        }
        p->resName[0] = (char) nlen - 1;

        SetCurResourceFile(curFile);
        curDepth = SetResourceFileDepth(curDepth);
    }
    return SetToolError(retVal);
}

/*
    fGetResourceName 008
    ---------------------------------------------------------------
        word    pCount          3
        word    resType         input
        Long    resID           input
        char   *resName         input pString buffer32

    Marc Wolfgram,  7/13/91 12:22:40
*/
word remGetResourceName(fResNameRecPtr p)
{
word i, j, len, retVal, typeCnt, itemCnt;
nameHndl    theHndl;
nameRec    *typeArray;
nameSubHndl listHndl;
nameSubRec *listArray;

    retVal = resNotFound;

    theHndl = workList[workIndex].resNameHndl;
    typeArray = (nameRec *) *theHndl;
    typeCnt = workList[workIndex].count;
    p->resName[0] = 0x00;

    switch(p->pCount) {
    case 3:
        for (i = 0; i < typeCnt; i++) {
            if (typeArray[i].nFlag & 0x4000) {
                typeCnt++;
                continue;
            }
            if (typeArray[i].type == p->resType) {
                listHndl = typeArray[i].itemHndl;
                listArray = (nameSubRec *) *listHndl;
                itemCnt = typeArray[i].count;
                for (j = 0; j < itemCnt; j++) {
                    if (listArray[j].nFlag & 0x4000) {
                        itemCnt++;
                        continue;
                    }
                    if (listArray[j].id == p->resID) {
                        if (listArray[j].name[0] > 8) {
                            len = listArray[j].name[0] - 9;
                            p->resName[0] = len;
                            strncpy(&p->resName[1], &listArray[j].name[10], len);
                        }
                        retVal = 0;
                        break;
                    }
                }
                break;
            }
        }
        break;

    default:
        retVal = invalidPcount;
    }

    return SetToolError(retVal);
}

/*
    fSetResourceName 009
    ---------------------------------------------------------------
        word    pCount          3
        word    resType         input
        Long    resID           input
        char   *resName         input pString buffer32

    Marc Wolfgram,  4/14/91 15:23:24
*/
word remSetResourceName(fResNameRecPtr p)
{
word    retVal;

    retVal = 0;

    if (p->pCount != 3)
        retVal = invalidPcount;
    else
        changeItem(workIndex, p->resType, p->resID, 0L, p->resName);

    return SetToolError(retVal);
}
